/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class EditorUtils {
    public static IEditorPart openInEditor(File file) {
        if (file == null) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)new IllegalArgumentException("file is null"));
            return null;
        }
        try {
            URI uri = file.toURI();
            IEditorDescriptor desc = EditorUtils.getEditorDescriptor(uri);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (desc == null) {
                return IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)"org.eclipse.ui.systemExternalEditor", (boolean)true);
            }
            return IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)desc.getId(), (boolean)true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)e);
            return null;
        }
    }

    public static IEditorDescriptor getEditorDescriptor(URI uri) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        if (uri.getPath() == null || uri.getPath().equals("/") || uri.getPath().trim().equals("")) {
            return null;
        }
        Path path = new Path(uri.getPath());
        return editorReg.getDefaultEditor(path.lastSegment());
    }

    public static void setOccurrenceColors() {
        UIJob job = new UIJob("Setting occurrence colors"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
                Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
                prefs.put("PHPReadOccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSearchResultColor()));
                prefs.put("PHPWriteOccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSearchResultColor()));
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(30);
        job.schedule();
    }

    public static final PHPSourceEditor getPHPSourceEditor(final ITextViewer viewer) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final PHPSourceEditor[] editorResult = new PHPSourceEditor[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart activeEditor = page.getActiveEditor();
                if (EditorUtils.isSameDocument(viewer, activeEditor)) {
                    editorResult[0] = (PHPSourceEditor)activeEditor;
                }
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorReference reference = references[i];
                    IEditorPart editor = reference.getEditor(false);
                    if (activeEditor != editor && EditorUtils.isSameDocument(viewer, editor)) {
                        editorResult[0] = (PHPSourceEditor)editor;
                    }
                    ++i;
                }
            }
        });
        return editorResult[0];
    }

    private static boolean isSameDocument(ITextViewer viewer, IEditorPart editor) {
        return editor instanceof PHPSourceEditor && ((PHPSourceEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput()) == viewer.getDocument();
    }
}

